(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13696,        392]
NotebookOptionsPosition[     12568,        349]
NotebookOutlinePosition[     13191,        373]
CellTagsIndexPosition[     13148,        370]
WindowTitle->Percolation on a Square Grid - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Percolation on a Square Grid", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"$RecursionLimit", "=", "25000"}], ",", 
       RowBox[{"w", "=", "h"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"per", "[", 
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "\[LessEqual]", "i", "\[LessEqual]", "w"}], "&&", 
          RowBox[{"1", "\[LessEqual]", "j", "\[LessEqual]", "h"}], "&&", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "1"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", "2"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"per", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"i", ",", "j"}], "}"}], "+", "#"}], "]"}], "&"}], "/@", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SeedRandom", "[", "2424", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"a", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Boole", "[", 
           RowBox[{"#", "<", "p"}], "]"}], "&"}], ",", 
         RowBox[{"RandomReal", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"w", ",", "h"}], "}"}]}], "]"}], ",", 
         RowBox[{"{", "2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "1"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"a", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "h"}], "]"}], "]"}], "=", "1"}]}], ";", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"per", "[", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1"}], "}"}], "]"}], ";", 
         RowBox[{"per", "[", 
          RowBox[{"{", 
           RowBox[{"i", ",", "h"}], "}"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "w"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ArrayPlot", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "a", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "450"}], ",", 
        RowBox[{"Mesh", "\[Rule]", "True"}], ",", 
        RowBox[{"ColorRules", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"0", "\[Rule]", "White"}], ",", 
           RowBox[{"1", "\[Rule]", 
            RowBox[{"Darker", "[", "Blue", "]"}]}], ",", 
           RowBox[{"2", "\[Rule]", "Red"}]}], "}"}]}]}], "]"}]}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", ".2", ",", "\"\<probability\>\""}], "}"}], ",", "0", 
     ",", "1", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"h", ",", "40", ",", "\"\<size\>\""}], "}"}], ",", "5", ",", 
     "100", ",", "1", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"AutorunSequencing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "30"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "10"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"TrackedSymbols", "\[RuleDelayed]", "Manipulate"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.386881080485209*^9, 3.3868810840905457`*^9}, {
   3.3868812254003153`*^9, 3.3868812269165077`*^9}, {3.3869449523782434`*^9, 
   3.3869449995038466`*^9}, {3.3869450343636675`*^9, 3.3869450346449213`*^9}},
 CellID->1758658384],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`h$$ = 40, $CellContext`p$$ = 0.2, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`p$$], 0.2, "probability"}, 0, 1}, {{
       Hold[$CellContext`h$$], 40, "size"}, 5, 100, 1}}, Typeset`size$$ = {
    450., {222., 227.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`p$79432$$ = 
    0, $CellContext`h$79433$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`h$$ = 40, $CellContext`p$$ = 0.2}, 
      "ControllerVariables" :> {
        Hold[$CellContext`p$$, $CellContext`p$79432$$, 0], 
        Hold[$CellContext`h$$, $CellContext`h$79433$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Block[{$CellContext`a, $RecursionLimit = 
         25000, $CellContext`w = $CellContext`h$$}, $CellContext`per[{
            Pattern[$CellContext`i$, 
             Blank[]], 
            Pattern[$CellContext`j$, 
             Blank[]]}] := If[
           And[
           1 <= $CellContext`i$ <= $CellContext`w, 
            1 <= $CellContext`j$ <= $CellContext`h$$, 
            Part[$CellContext`a, $CellContext`i$, $CellContext`j$] == 1], 
           Part[$CellContext`a, $CellContext`i$, $CellContext`j$] = 2; 
           Map[$CellContext`per[{$CellContext`i$, $CellContext`j$} + #]& , {{
             1, 0}, {0, 1}, {-1, 0}, {0, -1}}]]; 
        SeedRandom[2424]; $CellContext`a = Map[Boole[# < $CellContext`p$$]& , 
           RandomReal[{0, 1}, {$CellContext`w, $CellContext`h$$}], {2}]; 
        Part[$CellContext`a, All, 1] = (
          Part[$CellContext`a, All, $CellContext`h$$] = 1); 
        Do[$CellContext`per[{$CellContext`i, 
             1}]; $CellContext`per[{$CellContext`i, $CellContext`h$$}], \
{$CellContext`i, $CellContext`w}]; ArrayPlot[
          Transpose[$CellContext`a], ImageSize -> 450, Mesh -> True, 
          ColorRules -> {0 -> White, 1 -> Darker[Blue], 2 -> Red}]], 
      "Specifications" :> {{{$CellContext`p$$, 0.2, "probability"}, 0, 1, 
         Appearance -> "Labeled"}, {{$CellContext`h$$, 40, "size"}, 5, 100, 1,
          Appearance -> "Labeled"}}, 
      "Options" :> {
       AutorunSequencing -> {{1, 30}, {2, 10}}, TrackedSymbols :> Manipulate},
       "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{501., {282., 289.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->939693004]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Percolation on a Square Grid",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/PercolationOnASquareGrid/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/PercolationOnASquareGrid/"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/PercolationOnASquareGrid/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/PercolationOnASquareGrid/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/PercolationOnASquareGrid/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Stephen Wolfram",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Stephen+\
Wolfram"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Stephen+Wolfram"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->264309342],

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 system is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA 6 \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
PercolationOnASquareGrid"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Percolation on a Square Grid - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[618, 23, 220, 4, 70, "Section"],
Cell[CellGroupData[{
Cell[863, 31, 4343, 119, 265, "Input",
 CellID->1758658384],
Cell[5209, 152, 3122, 61, 588, "Output",
 CellID->939693004]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8380, 219, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[8756, 230, 925, 24, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9718, 259, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[10058, 270, 459, 15, 70, "Text",
 CellID->264309342],
Cell[10520, 287, 829, 24, 70, "Text"],
Cell[11352, 313, 1200, 33, 70, "Text"]
}, Open  ]]
}
]
*)

